# © 2025 Digital Advantage Corp.

######################################################################
#
# const.rb： 定数の設定
#
# for Ruby 3.2

######################################################################

########## ファイルやフォルダ  ##########
$base_dir = "./"
$data_dir = File.join($base_dir, "data/")
$temp_dir = File.join($base_dir, "temp/")

$nginx_real_ip_file_name = "real-ip-frontdoor.conf" # NGINXのreal_ipモジュール向け設定ファイル名

########## プロキシサーバ ##########
$proxy_servers = [
	nil, # プロキシを使わない
	# "http://＜ホスト名＞:＜ポート番号＞" のようなプロキシサーバURLを列挙する
]

########## クロール時のUser-Agent ##########
$crawl_user_agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36'

########## Microsoftダウンロードセンター「Azure IP Ranges and Service Tags – Public Cloud」 ##########
$msdc_page_url = 'https://www.microsoft.com/en-us/download/details.aspx?id=56519'
$msdc_confirm_file = File.join($temp_dir, "confirmation.html")
$msdc_json_url_file = File.join($data_dir, "latest_msdc_json_url.txt")

########## 終了コード ##########
module EXIT_CODE
	NORMAL_END					= 0.freeze
	GENERAL_FAILURE				= 1.freeze
	INVALID_OPTIONS				= 2.freeze
	INVALID_DB_SERVER			= 3.freeze
	DB_UPDATE_FAILURE			= 6.freeze
	FTP_FAILURE					= 7.freeze
	FILE_COPY_FAILURE			= 8.freeze
end
EXIT_CODE.freeze

########## 通知 ##########

# Eメール送信
# 以下、最寄りのSMTPゲートウェイ／サーバのパラメータを記入すること
$send_mail_options = {
	:address               => '＜SMTPサーバのFQDN＞',
	:port                  => 587, # SMTPポート番号
	:domain                => '＜ドメイン名＞',
	:user_name             => '＜認証ユーザー名＞',
	:password              => '＜認証パスワード＞',
	:authentication        => :login, # 必要なら:plainなどに変更
	:enable_starttls_auto  => true # 必要ならfalseに変更
}
$mail_sender = "＜送信元メールアドレス＞"
$mail_receiver_pc = "＜受信先メールアドレス（PC）＞"
$mail_receiver_mobile = "＜受信先メールアドレス（モバイル）＞"

########## App Serviceへのアップロード用FTPパラメータ ##########
$params_ftp_appsvc = {
	"desc" => "Azure App Service",
	"hostname" => '＜FTPホスト名＞.ftp.azurewebsites.windows.net', # App ServiceのFTPホスト名
	"username" => '＜FTPユーザー名＞', 
	"password" => '＜FTPパスワード＞',
	"is_ssl" => true, # FTPSが不可ならfalseに変更
	"remote_dir" => '/custom/etc/nginx/inc', # App Service側の保存先ディレクトリ名
}
