﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Net;
using System.Xml.Linq;
using AmazonProductAdvtApi;

namespace Core
{
    /// <summary>
    /// アマゾンのWebサービスを利用して書籍の検索を行います。
    /// このクラスでは、アマゾンのサンプルクラスであるSingedRequestHelperを利用してリクエストを作成します。
    /// </summary>
    /// <remarks>
    /// MY_AWS_ACCESS_KEY_IDとMY_AWS_SECRET_KEYについて
    /// 
    /// Amazon AWS Access Keyの取得と確認
    /// Amazon AWSを利用するためには、Amazon AWSのサイトで、自分のAccess key IDとSecret Access keyを確認する必要があります。Amazon AWSのAccess KeyはこのAmason AWSのポータルサイトで確認できるので、自分のAmazonアカウントでログインして確認して下さい。Access key Idが公開鍵で、Secret Access keyが秘密鍵になります。この２つのキーをもとにAWSを使うための署名を作成します。Secret Access keyは外部に漏れないように厳重に管理しましょう。
    /// Amazon AWSのポータルサイト⇒http://aws-portal.amazon.com/gp/aws/developer/account/index.html?action=access-key
    /// Amazon AWSに登録していない人や、Amazonのアカウントを持っていない人やはこのあたりのサイトを参考にAmazon AWSのアカウントを取得してください。
    /// Access Key IDの取得
    /// </remarks>
    public class AmazonService
    {
        private const string MY_AWS_ACCESS_KEY_ID = "アクセスキーを指定してください。";
        private const string MY_AWS_SECRET_KEY = "シークレットキーを指定してください。";
        private const string DESTINATION = "ecs.amazonaws.jp";

        public string Asin { get; set; }
        public string Url { get; set; }
        public string Author { get; set; }
        public string Title { get; set; }
        public string Manufacturer { get; set; }
        public string FormattedPrice { get; set; }
        public string ImageUrl { get; set; }

        public List<AmazonService> Find(string keyword)
        {
            if (string.IsNullOrEmpty(keyword))
            {
                return null;
            }

            var helper = new SignedRequestHelper(MY_AWS_ACCESS_KEY_ID, MY_AWS_SECRET_KEY, DESTINATION);
            var param = new Dictionary<string, String>();
            param["Service"] = "AWSECommerceService";
            param["Version"] = "2009-03-31";
            param["Operation"] = "ItemSearch";
            param["Keywords"] = keyword;
            param["SearchIndex"] = "Books";
            param["ResponseGroup"] = "Medium";

            var requestUrl = helper.Sign(param);
            var request = new WebClient() { Encoding = System.Text.Encoding.UTF8 };
            var downloadString = request.DownloadString(requestUrl);

            //ResponseGroup-Mediumで取得可能なXMLの要素は、次のWebページを参照すると分かりやすい
            //中規模な情報の取得(Medium)
            //http://www.ajaxtower.jp/ecs/responsegroup/index12.html
            var xml = XElement.Parse(downloadString);
            XNamespace ns = "http://webservices.amazon.com/AWSECommerceService/2009-03-31";
            return xml.Descendants(ns + "Item").Select(item =>
                {
                    var result = new AmazonService();

                    result.Asin = item.Element(ns + "ASIN").Value;
                    result.Url = item.Element(ns + "DetailPageURL").Value;
                    result.ImageUrl = item.Element(ns + "SmallImage").Element(ns + "URL").Value;

                    var attribute = item.Element(ns + "ItemAttributes");
                    result.Title = attribute.Element(ns + "Title").Value;
                    result.Author = attribute.Element(ns + "Author").Value;
                    result.Manufacturer = attribute.Element(ns + "Manufacturer").Value;
                    result.FormattedPrice = attribute.Element(ns + "ListPrice").Element(ns + "FormattedPrice").Value;
                    return result;
                         
                }).ToList();
        }
    }
}